'use strict';

(function($){
  $.fn.fader101 = function(options) {
    var target = this;
    
    var settings = {
      fade: {
        duration: 'slow',
        timeLapse: 3000
      },
      slide: {
        css: {
          background: '#fff'
        }
      }
    };
    
    var lastSettings = {
      container: {
        element: target,
        css: {
          width: target.width() + 'px',
          height: target.height() + 'px',
          position: 'relative'
        }
      },
      slide: {
        css: {
          width: target.width() + 'px',
          height: target.height() + 'px',
          position: 'absolute'
        }
      }
    };
    
    settings = $.extend(true, settings, options, lastSettings);
    
    settings.container.element.css(settings.container.css);
    settings.container.element.children().css(settings.slide.css);

    function addToQueue() {
      settings.container.element.prepend(settings.container.element.children(':last'));
      settings.container.element.children(':first').css({opacity: 1});
    }

    setInterval(function(){
      settings.container.element.children(':last').animate({opacity: 0}, settings.fade.duration, function(){
        addToQueue();
      });
    }, settings.fade.timeLapse);
  };
}(jQuery));