'use strict';

(function($){
  $.fn.slider101 = function(options) {
    var target = this;
    
    var settings = {
      buttons: {
        display: true,
        css: {
          width: Math.floor(target.width() * 0.1) + 'px',
          height: target.height() + 'px',
          font: 'normal 20px/' + target.height() + 'px sans-serif',
          color: '#00f',
          'text-align': 'center',
          cursor: 'pointer'
        }
      },
      animation: {
        timeRate: 3000
      }
    };
    
    var finalSettings = {
      window: {
        element: target,
        css: {
          position: 'relative',
          width: target.width() + 'px',
          height: target.height() + 'px',
          overflow: 'hidden'
        }
      },
      container: {
        element: null,
        css: {
          position: 'absolute',
          width: (target.width() * target.children().length) + 'px',
          height: target.height() + 'px',
          top: 0,
          left: 0
        }
      },
      slide: {
        css: {
          display: 'block',
          float: 'left',
          width: target.width() + 'px',
          height: target.height() + 'px'
        }
      },
      buttons: {
        left: {
          element: null,
          id: 'go-left',
          position: {
            top: 0,
            left: 0
          },
          label: '&laquo;'
        },
        right: {
          element: null,
          id: 'go-right',
          position: {
            top: 0,
            right: 0
          },
          label: '&raquo;'
        },
        css: {
          position: 'absolute'
        }
      },
      animation: {
        on: false,
        intervalId: null,
        step: target.width()
      }
    };

    settings = $.extend(true, settings, options, finalSettings);
    
    settings.window.element.css(settings.window.css);
    
    settings.container.element = $('<div>').css(settings.container.css).append(settings.window.element.children());
    settings.window.element.append(settings.container.element);
    
    settings.container.element.children().css(settings.slide.css);
    
    function slideAway(e) {
      settings.animation.on = true;
      settings.container.element.animate({left: nextPosition(e) + 'px'}, 'slow', function(){
        settings.animation.on = false;
      });
    };
    
    function nextPosition(e) {
      var nextPosition = 0;

      var containerPosition = parseInt(settings.container.element.css('left'));

      if (e && e.target && e.target.nodeName == 'A' && $(e.target).attr('id') == settings.buttons.left.id) {
        if (containerPosition < 0) {
          nextPosition = (parseInt(settings.container.element.css('left')) + settings.animation.step);
        } else {
          nextPosition = settings.animation.step * (settings.container.element.children().length - 1) * -1;
        }
      } else {
        if (!containerPosition || (containerPosition * -1) < (settings.container.element.width() - settings.animation.step)) {
          nextPosition = (parseInt(settings.container.element.css('left')) - settings.animation.step);
        } else {
          nextPosition = 0;
        }
      }

      return nextPosition;
    };

    function startInterval(e) {
      settings.animation.intervalId = setInterval(function(){
        slideAway(e);
      }, settings.animation.timeRate);
    }

    if (settings.buttons.display) {
      settings.buttons.left.element = $('<a>').html(settings.buttons.left.label)
                                              .attr('id', settings.buttons.left.id)
                                              .css(settings.buttons.css)
                                              .css(settings.buttons.left.position);
      settings.buttons.right.element = $('<a>').html(settings.buttons.right.label)
                                              .attr('id', settings.buttons.right.id)
                                              .css(settings.buttons.css)
                                              .css(settings.buttons.right.position);
                                      
      settings.window.element.append(settings.buttons.left.element);
      settings.window.element.append(settings.buttons.right.element);
      
      settings.buttons.left.element.click(function(e){
        if (settings.animation.on) return;

        clearInterval(settings.animation.intervalId);
        slideAway(e);
      });
      settings.buttons.right.element.click(function(e){
        if (settings.animation.on) return;

        clearInterval(settings.animation.intervalId);
        slideAway(e);
      });
    }
    
    settings.window.element.mouseenter(function(e) {
      clearInterval(settings.animation.intervalId);
    });
    settings.window.element.mouseleave(function(e) {
      startInterval(e);
    });
    
    startInterval(null);
    
  };
}(jQuery));