'use strict';

(function($){
  $.fn.hunterGame = function(){
    var gameBoard = this;
    
    var settings = {
      gameBoard: {
        element: gameBoard,
        css: {
          background: '#fff',
          color: '#000',
          position: 'relative'
        }
      },
      shootingRange: {
        element: null,
        css: {
          width: gameBoard.width() + 'px',
          height: (gameBoard.height() - 20) + 'px',
          position: 'relative'
        }
      },
      scoreBoard: {
        rabit: null,
        cherry: null,
        demon: null,
        css: {
          display: 'block',
          width: Math.floor(gameBoard.width() / 3) + 'px',
          height: '20px',
          position: 'absolute',
          'background-position': 'center left',
          'background-size': 'contain',
          'box-sizing': 'border-box',
          'padding-left': '25px'
        }
      },
      targets: {
        rabit: {
          life: function() {
            return 1500;
          },
          picture: {
            background: 'url(data:image/jpeg;base64,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) no-repeat center center'
          }
        },
        cherry: {
          life: function() {
            return 2000;
          },
          picture: {
            background: 'url(data:image/png;base64,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) no-repeat center center'
          }
        },
        demon: {
          life: function() {
            return Math.ceil(Math.random() * 3) * 1000;
          },
          picture: {
            background: 'url(data:image/png;base64,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) no-repeat center center'
          }
        }
      },
      targetCSS: {
        width: '20px',
        height: '20px',
        position: 'absolute',
        'background-size': 'contain'
      },
      timeLapse: 3000
    };
    
    settings.gameBoard.element.css(settings.gameBoard.css);
    
    settings.shootingRange.element = $('<div>').css(settings.shootingRange.css);
    settings.gameBoard.element.append(settings.shootingRange.element);
    
    settings.scoreBoard.rabit = $('<span>')
            .css({top: settings.shootingRange.element.height() + 'px', left: 0})
            .css(settings.targets.rabit.picture)
            .css(settings.scoreBoard.css)
            .text(0);
    settings.gameBoard.element.append(settings.scoreBoard.rabit);
    
    settings.scoreBoard.cherry = $('<span>')
            .css({top: settings.shootingRange.element.height() + 'px', left: Math.floor(gameBoard.width() / 3) + 'px'})
            .css(settings.targets.cherry.picture)
            .css(settings.scoreBoard.css)
            .text(0);
    settings.gameBoard.element.append(settings.scoreBoard.cherry);
    
    settings.scoreBoard.demon = $('<span>')
            .css({top: settings.shootingRange.element.height() + 'px', left: (Math.floor(gameBoard.width() / 3) * 2) + 'px'})
            .css(settings.targets.demon.picture)
            .css(settings.scoreBoard.css)
            .text(0);
    settings.gameBoard.element.append(settings.scoreBoard.demon);
    
    function drawTarget() {
      var target = selectRandomTarget();
      settings.shootingRange.element.append(target);
      setTimeout(function(){
        target.remove();
      }, target.attr('data-life'));
    }
    
    function selectRandomTarget() {
      var target = null;
      var scoreBoard = null;
      
      var targetSwitch = Math.round(Math.random() * 10);
      if (targetSwitch < 6) {
        target = settings.targets.rabit;
        scoreBoard = settings.scoreBoard.rabit;
      } else if (targetSwitch < 9) {
        target = settings.targets.cherry;
        scoreBoard = settings.scoreBoard.cherry;
      } else {
        target = settings.targets.demon;
        scoreBoard = settings.scoreBoard.demon;
      }

      var position = {
        top: Math.floor(Math.random() * (settings.shootingRange.element.height() - parseInt(settings.targetCSS.height))) + 'px',
        left: Math.floor(Math.random() * (settings.shootingRange.element.width() - parseInt(settings.targetCSS.width))) + 'px'
      };
      
      return $('<div>')
              .attr('data-life', target.life())
              .css(target.picture)
              .css(position)
              .css(settings.targetCSS)
              .click(function(){
                cashIn(this, scoreBoard);
              });
    }
    
    function cashIn(target, scoreBoard) {
      scoreBoard.text(parseInt(scoreBoard.text()) + 1);
      target.remove();
    }
    
    function runInterval() {
      drawTarget();
      
      setTimeout(function(){
        runInterval();
      }, settings.timeLapse);
    }
    
    runInterval();
  };
}(jQuery));